/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core;

import icyllis.modernui.ModernUI;
import icyllis.modernui.core.DefinePlugin;
import icyllis.modernui.core.Plugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class PluginList {
    private static PluginList sInstance;
    private final List<Plugin> mPlugins = new ArrayList<Plugin>();

    private PluginList() {
    }

    private void scanPlugins() {
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        Type target = Type.getType(DefinePlugin.class);
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            for (ModFileScanData.AnnotationData data : scanData.getAnnotations()) {
                if (!data.getAnnotationType().equals((Object)target)) continue;
                try {
                    String pid = (String)data.getAnnotationData().get("value");
                    Plugin v = plugins.putIfAbsent(pid, Class.forName(data.getMemberName()).asSubclass(Plugin.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    if (v == null) continue;
                    ModernUI.LOGGER.error(ModernUI.MARKER, "{} is annotated with the same plugin id {} as {}", (Object)data.getMemberName(), (Object)pid, (Object)v);
                }
                catch (Throwable throwable) {
                    ModernUI.LOGGER.error(ModernUI.MARKER, "Failed to load plugin: {}", (Object)data.getMemberName(), (Object)throwable);
                }
            }
        }
        this.mPlugins.addAll(plugins.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static PluginList get() {
        if (sInstance != null) return sInstance;
        Class<PluginList> clazz = PluginList.class;
        synchronized (PluginList.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PluginList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public int size() {
        return this.mPlugins.size();
    }
}

